/**
* Script: shopstate.js
* Written by: Radnen
* Updated: 12/28/2010
**/

System.itemWindow = Resources.windowstyles.items;
RequireScript("ui/itemset.js");

function ShopState(planet, name)
{
	if (!name) name = "ShopState";
	this.inherit = State;
	this.inherit(name);
	
	this.x = SW/2-250;
	this.y = SH/2-166;
	this.planet = planet;
	this.credits = new TimedValue(Genesis.player.credits, 500);
	
	var c_holder = new ControlHolder(0, 0, SW, SH);
	var panel = new Panel(c_holder, this.x, this.y, SW, SH);
	
	var items = new ItemSet(panel, 72, 72, 5, 4, 32, 32);
	var i = Utility.random(8);
	while(i--) {
		items.items.push(Utility.random(Items.length-1));
	}
	
	var backitem = new EasyButton("Back", this.x+100, this.y+280);
	backitem.onClick.add(function(sender) {
		Audio.playSound(System.cancelSnd);
		sender.hide();
	}, this);
	var okayitem = new EasyButton("Buy Item", this.x+340, this.y+280);
	okayitem.onClick.add(function(sender) {
		if (items.item.price > Genesis.player.credits) {
			Audio.playSound(System.cantSnd);
			return;
		}
		else {
			/* Purchase the item! */
			Audio.playSound(Resources.sounds.money);
		}
	}, this);
	
	this.render.add(function() {
		Resources.images.questmenu.blit(this.x, this.y);
		SetClippingRectangle(this.x+315, this.y+12, 182, 234);
		Resources.images[this.planet.image].blit(this.x + 315, this.y+64);
		SetClippingRectangle(0, 0, SW, SH);
		if (items.item != null) {
			Rectangle(this.x+285, this.y+12, 212, 234, Colors.clearBlack);
			System.windowFont.drawText(this.x+285, this.y+12, "Buy Item: ");
			System.windowFont.drawText(this.x+285, this.y+28, Items[items.item].name);
			System.windowFont.drawText(this.x+285, this.y+60, "Cost: " + Items[items.item].price);
			System.windowFont.drawText(this.x+285, this.y+76, "Credits: " + this.credits.value);
		}
		c_holder.draw();
		Rectangle(this.x+24, this.y+16, 260, 20, Colors.clearBlack);
		System.textFont.drawText(this.x+24, this.y+16, "Planet's Items:");
		if (items.length == 0)
			System.textFont.drawText(this.x+285, this.y+12, "[No Items Available]");
		backitem.draw();
		okayitem.draw();
	});
	
	this.update.add(function() {
		c_holder.update();
		backitem.update();
		okayitem.update();
	});
	
	c_holder.controls.push(panel);
	c_holder.focusedControl = panel;
	panel.controls.push(items);
}